// This file is part of the Attempto Java Packages.
// Copyright 2008, Attempto Group, University of Zurich (see http://attempto.ifi.uzh.ch).
//
// The Attempto Java Packages is free software: you can redistribute it and/or modify it under the
// terms of the GNU Lesser General Public License as published by the Free Software Foundation,
// either version 3 of the License, or (at your option) any later version.
//
// The Attempto Java Packages is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License along with the Attempto
// Java Packages. If not, see http://www.gnu.org/licenses/.

package ch.uzh.ifi.attempto.chartparser;

/**
 * This class represents a string object that can unify with other string objects.
 * 
 * @author Tobias Kuhn
 */
public class StringRef {
	
	private StringEntity stringEntity;
	
	/**
	 * Creates a new string object with null as value.
	 */
	public StringRef() {
		this((String) null);
	}
	
	/**
	 * Creates a new string object with the given value.
	 * 
	 * @param string The value of the new string object.
	 */
	public StringRef(String string) {
		stringEntity = new StringEntity(string);
		stringEntity.addReference(this);
	}
	
	StringRef(StringEntity stringEntity) {
		this.stringEntity = stringEntity;
		stringEntity.addReference(this);
	}
	
	void setStringEntity(StringEntity stringEntity) {
		this.stringEntity = stringEntity;
	}
	
	/**
	 * Unifies this string object with another string object. If unification is not possible,
	 * an exception is thrown.
	 * 
	 * @param stringObj The string object to be unified with this string object.
	 * @throws UnificationFailedException If unification fails.
	 */
	public void unify(StringRef stringObj) throws UnificationFailedException {
		stringEntity.unify(stringObj.stringEntity);
	}
	
	/**
	 * Returns the value of this string object.
	 * 
	 * @return The value of this string object.
	 */
	public String getString() {
		return stringEntity.getString();
	}
	
	int getID() {
		return stringEntity.getID();
	}
	
	StringEntity getStringEntity() {
		return stringEntity;
	}

}
