// This file is part of the Attempto Java Packages.
// Copyright 2008, Attempto Group, University of Zurich (see http://attempto.ifi.uzh.ch).
//
// The Attempto Java Packages is free software: you can redistribute it and/or modify it under the
// terms of the GNU Lesser General Public License as published by the Free Software Foundation,
// either version 3 of the License, or (at your option) any later version.
//
// The Attempto Java Packages is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License along with the Attempto
// Java Packages. If not, see http://www.gnu.org/licenses/.

package ch.uzh.ifi.attempto.preditor.text;

/**
 * This class represents referenceable text elements that contain a noun. One can refer to such
 * text elements with "the" plus the respective noun, e.g. "the customer" in the case of the noun
 * "customer". If the text element is followed by a {@link VarTextElement} then the variable is
 * also included in the reference text, e.g. "the customer X" if the variable has the name "X".
 * 
 * @author Tobias Kuhn
 */
public class NounTextElement extends BasicTextElement implements RefableTextElement {
	
	private VarTextElement varTextElement;
	
	/**
	 * Creates a new noun text element.
	 * 
	 * @param noun The noun.
	 * @param category The category.
	 */
	public NounTextElement(String noun, String category) {
		super(noun, category);
	}

	public void checkNeighborTextElements(TextElement precedingTextElement, TextElement nextTextElement) {
		if (nextTextElement instanceof VarTextElement) {
			this.varTextElement = (VarTextElement) nextTextElement;
		} else {
			this.varTextElement = null;
		}
	}

	public String getReferenceText() {
		if (varTextElement == null) {
			return "the " + getText();
		}
		return "the " + getText() + " " + varTextElement.getText();
	}

}
