// This file is part of the Attempto Java Packages.
// Copyright 2008, Attempto Group, University of Zurich (see http://attempto.ifi.uzh.ch).
//
// The Attempto Java Packages is free software: you can redistribute it and/or modify it under the
// terms of the GNU Lesser General Public License as published by the Free Software Foundation,
// either version 3 of the License, or (at your option) any later version.
//
// The Attempto Java Packages is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License along with the Attempto
// Java Packages. If not, see http://www.gnu.org/licenses/.

package ch.uzh.ifi.attempto.preditor.text;

/**
 * This class represents a text element that is a reference to a preceding text element.
 * 
 * @see RefableTextElement
 * @author Tobias Kuhn
 */
public class RefTextElement implements TextElement {
	
	private RefableTextElement refableTextElement;
	private String category;
	private boolean sentenceInitial = false;
	
	/**
	 * Creates a new reference text element that refers to the given referenceable text element.
	 * 
	 * @param refableTextElement The referenceable text element occurring earlier in the text.
	 * @param category The category of the reference text element.
	 */
	public RefTextElement(RefableTextElement refableTextElement, String category) {
		this.refableTextElement = refableTextElement;
		this.category = category;
	}

	public String getText() {
		String t = refableTextElement.getReferenceText();
		if (sentenceInitial) {
			return t.substring(0, 1).toUpperCase() + t.substring(1);
		} else {
			return t;
		}
	}

	public String getCategory() {
		return category;
	}

	public void checkNeighborTextElements(TextElement precedingTextElement, TextElement nextTextElement) {
		sentenceInitial = (precedingTextElement == null || precedingTextElement.getText().matches("(\\.|\\?|\\!)"));
	}
	
	public boolean equals(Object obj) {
		if (obj instanceof RefTextElement) {
			RefTextElement other = (RefTextElement) obj;
			return (this.refableTextElement == other.refableTextElement);
		}
		return false;
	}

}
