// This file is part of the Attempto Java Packages.
// Copyright 2008, Attempto Group, University of Zurich (see http://attempto.ifi.uzh.ch).
//
// The Attempto Java Packages is free software: you can redistribute it and/or modify it under the
// terms of the GNU Lesser General Public License as published by the Free Software Foundation,
// either version 3 of the License, or (at your option) any later version.
//
// The Attempto Java Packages is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License along with the Attempto
// Java Packages. If not, see http://www.gnu.org/licenses/.

package ch.uzh.ifi.attempto.preditor.text;

/**
 * This interface describes a text element (a word or phrase) that is used by the
 * predictive editor. Every text element contains a text and a grammatical category.
 * 
 * @author Tobias Kuhn
 */
public interface TextElement {
	
	/**
	 * Returns the text of this text element.
	 * 
	 * @return The text.
	 */
	public String getText();
	
	/**
	 * Returns the grammatical category of this text element.
	 * 
	 * @return The grammatical category.
	 */
	public String getCategory();
	
	/**
	 * Checks the preceding and next text element. This is needed for words that change their form
	 * depending on the context, e.g. for capitalization or for the indefinite article "a"/"an".
	 * 
	 * @param precedingTextElement
	 */
	public void checkNeighborTextElements(TextElement precedingTextElement, TextElement nextTextElement);
	
	public boolean equals(Object obj);

}
