// This file is part of the Attempto Java Packages.
// Copyright 2008, Attempto Group, University of Zurich (see http://attempto.ifi.uzh.ch).
//
// The Attempto Java Packages is free software: you can redistribute it and/or modify it under the
// terms of the GNU Lesser General Public License as published by the Free Software Foundation,
// either version 3 of the License, or (at your option) any later version.
//
// The Attempto Java Packages is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License along with the Attempto
// Java Packages. If not, see http://www.gnu.org/licenses/.

package ch.uzh.ifi.attempto.acewiki;

import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.ContentPane;
import nextapp.echo2.app.Window;
import nextapp.echo2.webcontainer.ContainerContext;
import ch.uzh.ifi.attempto.acewiki.core.ontology.Ontology;
import ch.uzh.ifi.attempto.acewiki.gui.page.LoginScreen;
import ch.uzh.ifi.attempto.echocomp.ServerDelayMessage;
import ch.uzh.ifi.attempto.echocomp.Style;

/**
 * This non-public class represents an AceWiki application instance.
 * 
 * @author Tobias Kuhn
 */
class AceWikiApp extends ApplicationInstance {
	
	private static final long serialVersionUID = -2038165609406790355L;
	
	public static final int NO_LOGIN = 0;
	public static final int NONPW_LOGIN = 1;
	public static final int PW_LOGIN = 2;

	private static int sessionID = 1;
	
	private String title, description;
	private Ontology ontology;
	private int login;
	private Wiki wiki;
	private Window window;
	
	/**
	 * Creates a new AceWiki application instance.
	 * 
	 * @param ontology The ontology that should be shown in the wiki.
	 * @param title The title of the wiki.
	 * @param description The description of the wiki.
	 * @param login true if the user should have to login (rudimentary implementation).
	 */
	public AceWikiApp(Ontology ontology, String title, String description, int login) {
		this.ontology = ontology;
		this.title = title;
		this.description = description;
		this.login = login;
	}
	
	public Window init() {
		setStyleSheet(Style.styleSheet);
		window = new Window();
		wiki = new Wiki(ontology, title, description, sessionID++);
		wiki.log("syst", "start session");
		if (login == NO_LOGIN) {
			window.setContent(wiki.getContentPane());
		} else {
			ContentPane contentPane = new ContentPane();
			contentPane.add(new LoginScreen(wiki, window, title, login == PW_LOGIN));
			window.setContent(contentPane);
		}
		window.setTitle("AceWiki");
		
		ContainerContext cc = (ContainerContext) ApplicationInstance.getActive().getContextProperty(ContainerContext.CONTEXT_PROPERTY_NAME);
		cc.setServerDelayMessage(new ServerDelayMessage("Please wait...", "../wait.gif"));
		// (The wait icon should be copied at the right place on the server.)
		
		return window;
	}
	
	/**
	 * Logs out the current user. Note that login/logout is only implemented very rudimentary at the
	 * moment.
	 */
	public void logout() {
		if (login == NO_LOGIN) return;
		wiki.log("syst", "logout");
		wiki = new Wiki(ontology, title, description, sessionID++);
		wiki.log("syst", "start session");
		ContentPane contentPane = new ContentPane();
		contentPane.add(new LoginScreen(wiki, window, title, login == PW_LOGIN));
		window.setContent(contentPane);
	}
	
	/**
	 * Returns the wiki instance.
	 * 
	 * @return The wiki instance.
	 */
	public Wiki getWiki() {
		return wiki;
	}

}