// This file is part of the Attempto Java Packages.
// Copyright 2008, Attempto Group, University of Zurich (see http://attempto.ifi.uzh.ch).
//
// The Attempto Java Packages is free software: you can redistribute it and/or modify it under the
// terms of the GNU Lesser General Public License as published by the Free Software Foundation,
// either version 3 of the License, or (at your option) any later version.
//
// The Attempto Java Packages is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License along with the Attempto
// Java Packages. If not, see http://www.gnu.org/licenses/.

package ch.uzh.ifi.attempto.chartparser;

import java.util.ArrayList;
import java.util.HashMap;


class Chart {
	
	private ArrayList<Edge> edges = new ArrayList<Edge>();
	private HashMap<Integer, ArrayList<Edge>> edgesByEndPos = new HashMap<Integer, ArrayList<Edge>>();
	private HashMap<Integer, HashMap<String, ArrayList<Edge>>> edgesByEndPosAndActCat = new HashMap<Integer, HashMap<String, ArrayList<Edge>>>();
	
	
	public Chart() {
	}
	
	public boolean addEdge(Edge edge) {
		ArrayList<Edge> l = edgesByEndPos.get(edge.getEndPos());
		if (l == null) {
			l = new ArrayList<Edge>();
			edgesByEndPos.put(edge.getEndPos(), l);
		}
		boolean isNewEdge = true;
		for (Edge e : l) {
			if (e.subsumes(edge)) {
				e.addLinksFrom(edge);
				isNewEdge = false;
			}
		}
		if (isNewEdge) {
			edges.add(edge);
			l.add(edge);
			int p = edge.getEndPos();
			String n = null;
			if (edge.isActive()) {
				n = edge.getNextActive().getName();
			}
			HashMap<String, ArrayList<Edge>> h = edgesByEndPosAndActCat.get(p);
			if (h == null) {
				h = new HashMap<String, ArrayList<Edge>>();
				edgesByEndPosAndActCat.put(p, h);
			}
			ArrayList<Edge> l2 = h.get(n);
			if (l2 == null) {
				l2 = new ArrayList<Edge>();
				h.put(n, l2);
			}
			l2.add(edge);
		}
		return isNewEdge;
	}
	
	public ArrayList<Edge> getEdgesByEndPos(int endPos, boolean copy) {
		ArrayList<Edge> l = edgesByEndPos.get(endPos);
		if (l != null) {
			if (copy) {
				return new ArrayList<Edge>(l);
			} else {
				return l;
			}
		}
		return new ArrayList<Edge>();
	}
	
	public ArrayList<Edge> getEdgesByEndPosAndActCat(int endPos, String actCatName, boolean copy) {
		HashMap<String, ArrayList<Edge>> h = edgesByEndPosAndActCat.get(endPos);
		if (h != null) {
			ArrayList<Edge> l = h.get(actCatName);
			if (l != null) {
				if (copy) {
					return new ArrayList<Edge>(l);
				} else {
					return l;
				}
			}
		}
		return new ArrayList<Edge>();
	}
	
	public void removeEdgesWithEndPos(int endPos) {
		ArrayList<Edge> l = edgesByEndPos.get(endPos);
		if (l == null) return;
		for (Edge e : l) {
			edges.remove(e);
		}
		l.clear();
		
		HashMap<String, ArrayList<Edge>> h = edgesByEndPosAndActCat.get(endPos);
		if (h == null) return;
		h.clear();
	}
	
	public void clear() {
		edges.clear();
		edgesByEndPos.clear();
		edgesByEndPosAndActCat.clear();
	}
	
	public String toString() {
		String s = "";
		for (Edge e : edges) {
			s += e + "\n";
		}
		return s;
	}

}
