// This file is part of the Attempto Java Packages.
// Copyright 2008, Attempto Group, University of Zurich (see http://attempto.ifi.uzh.ch).
//
// The Attempto Java Packages is free software: you can redistribute it and/or modify it under the
// terms of the GNU Lesser General Public License as published by the Free Software Foundation,
// either version 3 of the License, or (at your option) any later version.
//
// The Attempto Java Packages is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License along with the Attempto
// Java Packages. If not, see http://www.gnu.org/licenses/.

package ch.uzh.ifi.attempto.preditor;

import ch.uzh.ifi.attempto.echocomp.Style;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Font;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.ActionListener;

/**
 * This abstract class represents a menu item that performs an action when the user clicks on it.
 * 
 * @author Tobias Kuhn
 */
public abstract class SpecialMenuItem extends MenuItem implements ActionListener {
	
	/**
	 * A new special menu item is initialized.
	 * 
	 * @param text The text of the menu item.
	 */
	public SpecialMenuItem(String text) {
		setText(text);
		setActionCommand(text);
        setFont(new Font(Style.fontTypeface, Font.ITALIC, new Extent(12)));
		setForeground(Style.mediumForeground);
		addActionListener(this);
    }
	
	/**
	 * The implementation of this abstract method defines the action that is done when the
	 * user clicks on the menu item.
	 */
	public abstract void action();

	public void actionPerformed(ActionEvent e) {
		action();
	}
	
	public void addActionListener(ActionListener actionListener) {
		if (!(actionListener instanceof PreditorWindow)) {
			super.addActionListener(actionListener);
		}
	}

	public boolean equals(Object obj) {
		if (obj instanceof SpecialMenuItem) {
			return getText().equals(((SpecialMenuItem) obj).getText());
		}
		return false;
	}
    
}
