// This file is part of the Attempto Java Packages.
// Copyright 2008, Attempto Group, University of Zurich (see http://attempto.ifi.uzh.ch).
//
// The Attempto Java Packages is free software: you can redistribute it and/or modify it under the
// terms of the GNU Lesser General Public License as published by the Free Software Foundation,
// either version 3 of the License, or (at your option) any later version.
//
// The Attempto Java Packages is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE. See the GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License along with the Attempto
// Java Packages. If not, see http://www.gnu.org/licenses/.

package ch.uzh.ifi.attempto.preditor.text;

/**
 * This class represents referencable texts elements that contain a variable.
 * 
 * @author Tobias Kuhn
 */
public class VarTextElement extends BasicTextElement implements RefableTextElement {
	
	/**
	 * Creates a new variable text element.
	 * 
	 * @param varName The name of the variable, e.g. "X".
	 * @param category The category.
	 */
	public VarTextElement(String varName, String category) {
		super(varName, category);
	}
	
	public String getReferenceText() {
		return getText();
	}

}
